/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.ByteArrayVirtualFile;
import jpcsp.HLE.VFS.FakeVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.crypto.PBPVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.crypto.AMCTRL;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.hardware.Model;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class scePopsMan
extends HLEModule {
    public static Logger log = Modules.getLogger("scePopsMan");
    public static final String EBOOT_PBP = "EBOOT.PBP";
    private static final String KEYS_BIN = "KEYS.BIN";
    private static final String ebootDummyFileName = "ms0:/PSP/GAME/DUMMY0000/EBOOT.PBP";
    private static final int COMPILED_SKD_VERSION = 0x3050000;
    private int POPS_DECOMPRESS_DATA_ADDRESS;
    private int POPS_START_ADDRESS;
    private String ebootPbp;
    private int ebootPbpUid;
    private IVirtualFile vFileEbootPbp;
    private int getIdFunction;
    private boolean isCustomPs1;
    private byte[] ebootKey;

    public static byte[] readEbootKeys(String ebootFileName) throws IOException {
        File keysFile;
        if (ebootFileName == null || !ebootFileName.endsWith(EBOOT_PBP)) {
            return null;
        }
        String keysFileName = ebootFileName.substring(0, ebootFileName.length() - EBOOT_PBP.length()) + KEYS_BIN;
        byte[] key = Utilities.readCompleteFile(keysFileName);
        if (key == null && (keysFile = new File(keysFileName)).canRead() && keysFile.length() > 0L) {
            FileInputStream is = new FileInputStream(keysFile);
            key = new byte[(int)keysFile.length()];
            ((InputStream)is).read(key);
            ((InputStream)is).close();
        }
        return key;
    }

    public byte[] getEbootKey() {
        return this.ebootKey;
    }

    @Override
    public void start() {
        this.POPS_DECOMPRESS_DATA_ADDRESS = HLEUtilities.getInstance().installHLESyscall(this, "hlePopsDecompressData");
        this.POPS_START_ADDRESS = HLEUtilities.getInstance().installHLESyscall(this, "hlePopsStartHandler");
        super.start();
    }

    public void loadOnDemand(SceModule module) throws IOException {
        String ebootFileName = module.pspfilename;
        this.ebootKey = scePopsMan.readEbootKeys(ebootFileName);
        PBPVirtualFile ebootVirtualFile = new PBPVirtualFile(this.ebootKey, new LocalVirtualFile(new SeekableRandomFile(ebootFileName, "r")));
        FakeVirtualFileSystem.getInstance().registerFakeVirtualFile(ebootDummyFileName, ebootVirtualFile);
        module.pspfilename = ebootDummyFileName;
        LocalVirtualFile vFile = new LocalVirtualFile(new SeekableRandomFile(ebootFileName, "r"));
        byte[] header = new byte[40];
        vFile.ioRead(header, 0, header.length);
        int pspDataOffset = Utilities.readUnaligned32(header, 32);
        int licenseNameOffset = pspDataOffset + 1376;
        vFile.ioLseek(licenseNameOffset);
        byte[] licenseBuffer = new byte[36];
        vFile.ioRead(licenseBuffer, 0, licenseBuffer.length);
        String licenseName = new String(licenseBuffer);
        String licenseFileName = "ms0:/PSP/LICENSE/" + licenseName + ".rif";
        byte[] fakeLicenseBuffer = new byte[152];
        Utilities.writeStringNZ(fakeLicenseBuffer, 16, 48, licenseName);
        ByteArrayVirtualFile fakeLicenseVirtualFile = new ByteArrayVirtualFile(fakeLicenseBuffer);
        FakeVirtualFileSystem.getInstance().registerFakeVirtualFile(licenseFileName, fakeLicenseVirtualFile);
        int psarDataOffset = Utilities.readUnaligned32(header, 36);
        vFile.ioLseek(psarDataOffset);
        byte[] psTitleBuffer = new byte[7];
        vFile.ioRead(psTitleBuffer, 0, psTitleBuffer.length);
        int pgdOffset = psarDataOffset;
        pgdOffset = "PSTITLE".equals(new String(psTitleBuffer)) ? (pgdOffset += 512) : (pgdOffset += 1024);
        vFile.ioLseek(pgdOffset);
        byte[] pgdHeader = new byte[4];
        vFile.ioRead(pgdHeader, 0, pgdHeader.length);
        boolean bl = this.isCustomPs1 = Utilities.readUnaligned32(pgdHeader, 0) != 1145524224;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("loadOnDemand isCustomPs1=%b", this.isCustomPs1));
        }
        vFile.ioClose();
        RuntimeContextLLE.enableLLE();
        RuntimeContextLLE.createMMIO();
        Modules.SysMemUserForUserModule.hleSetCompiledSdkVersion(0x3050000);
        Modules.InitForKernelModule.setApplicationType(768);
        Modules.InitForKernelModule.setBootFrom(64);
        Memory mem = RuntimeContextLLE.getMMIO();
        mem.write32(-1077936128, 1086468096);
        mem.write32(-1077936124, 1073917952);
        mem.write32(-1077936120, 335675405);
        mem.write32(-1077936116, 0);
        Modules.ModuleMgrForUserModule.hleKernelLoadAndStartModule("flash0:/kd/popsman.prx", 16);
    }

    public void patchModule(Memory mem, SceModule module) {
        if ("pops".equals(module.modname) && this.isCustomPs1) {
            int[] decompPatchOffsets = new int[]{56184, 56184, 56184, 56296, 58112, -559038737, 56296, -559038737, 56296, -559038737, 56296};
            Utilities.patch(mem, module, decompPatchOffsets[Model.getGeneration()], 0xE000000, HLEUtilities.JAL(this.POPS_DECOMPRESS_DATA_ADDRESS), -33554432);
        }
    }

    public int hookDrmBBMacFinal2(AMCTRL.BBMac_Ctx ctx, int result) {
        if (this.isCustomPs1) {
            result = 0;
        }
        return result;
    }

    @HLEFunction(nid=-1, version=150)
    public int hlePopsDecompressData(int destSize, TPointer src, TPointer dest) {
        int result = Modules.UtilsForKernelModule.sceKernelDeflateDecompress(dest, destSize, src, TPointer32.NULL);
        if (result >= 0) {
            result = 37631;
        }
        return result;
    }

    public void hlePopsRegisterGetIdFunc(TPointer getIdFunction) {
        this.getIdFunction = getIdFunction.getAddress();
        SceKernelThreadInfo rootThread = Modules.ThreadManForUserModule.getRootThread(null);
        rootThread.cpuContext.pc = this.POPS_START_ADDRESS;
        rootThread.cpuContext.npc = this.POPS_START_ADDRESS;
    }

    @HLEFunction(nid=-1, version=150)
    public int hlePopsStartHandler(int argumentSize, TPointer argument) {
        SceKernelThreadInfo rootThread = Modules.ThreadManForUserModule.getCurrentThread();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hlePopsStartHandler getIdFunction=0x%08X, rootThread=%s, rootThreadEntry=0x%08X", this.getIdFunction, rootThread, rootThread.entry_addr));
        }
        int keySize = 16;
        SysMemUserForUser.SysMemInfo keyBufferInfo = Modules.SysMemUserForUserModule.malloc(2, "hlePopsStartHandler", 1, 16, 0);
        TPointer fileNameAddr = new TPointer(argument);
        TPointer keyBuffer = new TPointer(this.getMemory(), keyBufferInfo.addr);
        keyBuffer.clear(16);
        Modules.ThreadManForUserModule.executeCallback(rootThread, this.getIdFunction, null, false, fileNameAddr.getAddress(), keyBuffer.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hlePopsStartHandler getIfFunction returning keyBuffer: %s", Utilities.getMemoryDump(keyBuffer, 16)));
        }
        Modules.SysMemUserForUserModule.free(keyBufferInfo);
        Modules.ThreadManForUserModule.executeCallback(rootThread, rootThread.entry_addr, null, false, argumentSize, argument.getAddress());
        return 0;
    }

    @HLEFunction(nid=699661092, version=150)
    public int scePopsManLoadModule(PspString ebootPbp, int unknown) {
        this.ebootPbp = ebootPbp.getString();
        this.ebootPbpUid = -1;
        this.vFileEbootPbp = null;
        String popsFileName = String.format("flash0:/kd/pops_%02dg.prx", Model.getGeneration());
        return Modules.ModuleMgrForUserModule.hleKernelLoadAndStartModule(popsFileName, 32);
    }

    @HLEUnimplemented
    @HLEFunction(nid=9482952, version=150)
    public int scePopsManExitVSHKernel() {
        return Modules.LoadExecForKernelModule.sceKernelExitVSHKernel(TPointer.NULL);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1923479598, version=150)
    public int sceMeAudio_8D5A07D2() {
        this.ebootPbpUid = 4660;
        try {
            this.vFileEbootPbp = new LocalVirtualFile(new SeekableRandomFile(new File(this.ebootPbp), "r"));
        }
        catch (FileNotFoundException e) {
            log.error((Object)"sceMeAudio_8D5A07D2", (Throwable)e);
        }
        return this.ebootPbpUid;
    }

    @HLEUnimplemented
    @HLEFunction(nid=817771748, version=150)
    public int sceMeAudio_30BE34E4(int uid, TPointer dataAddr, int offset, int size) {
        if (uid != this.ebootPbpUid) {
            return -1;
        }
        long seekOffset = (long)offset & 0xFFFFFFFFL;
        long result = this.vFileEbootPbp.ioLseek(seekOffset);
        if (result != seekOffset) {
            return -1;
        }
        return this.vFileEbootPbp.ioRead(dataAddr, size);
    }

    @HLEUnimplemented
    @HLEFunction(nid=195811680, version=150)
    public int sceMeAudio_0BABD960() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=262311910, version=150)
    public int sceMeAudio_0FA28FE6() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=340032416, version=150)
    public int sceMeAudio_14447BA0() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=438550676, version=150)
    public int sceMeAudio_1A23C094() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=716504643, version=150)
    public int sceMeAudio_2AB4FE43() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=717638719, version=150)
    public int sceMeAudio_2AC64C3F() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=930161308, version=150)
    public int sceMeAudio_3771229C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1123084855, version=150)
    public int sceMeAudio_42F0EA37() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1331391874, version=150)
    public int sceMeAudio_4F5B6D82() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1384277754, version=150)
    public int sceMeAudio_528266FA(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=1024, usage=BufferInfo.Usage.inout) TPointer buffer) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1425190482, version=150)
    public int sceMeAudio_54F2AE52() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1757765452, version=150)
    public int sceMeAudio_68C55F4C(boolean unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1774501067, version=150)
    public int sceMeAudio_69C4BCCB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2141384187, version=150)
    public int sceMeAudio_805D1205() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2093511150, version=150)
    public int sceMeAudio_83378E12() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1970405865, version=150)
    public int sceMeAudio_8A8DFE17() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1689604227, version=150)
    public int sceMeAudio_9B4AAF7D() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1494360298, version=150)
    public int sceMeAudio_A6EDDF16(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer timeAddr) {
        timeAddr.clear(16);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1369783435, version=150)
    public int sceMeAudio_AE5AC375() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1117817207, version=150)
    public int sceMeAudio_BD5F7689() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-918792456, version=150)
    public int sceMeAudio_C93C56F8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-722370732, version=150)
    public int sceMeAudio_D4F17F54() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-563933998, version=150)
    public int sceMeAudio_DE630CD2(int unknown, int spRegisterValue) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1880409408, version=150)
    public int sceMeAudio_7014C540(int geListId, int stallAddr) {
        return 0;
    }

    @HLEFunction(nid=-403673557, version=150)
    public void sceMeAudio_E7F06E2B_setGeStallAddress(int stallAddr) {
        RuntimeContextLLE.getMMIO().write32(-1119878900, stallAddr);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-385372567, version=150)
    public int sceMeAudio_E907AE69() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-161252750, version=150)
    public int sceMeAudio_F6637A72() {
        return 0;
    }
}

